/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.Util;

public class ArmorDominateModifier
extends Modifier
implements AttributesModifierHook,
InventoryTickModifierHook,
TooltipModifierHook,
ModifierRemovalHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "dominate_armor");
    private static final Component ATTACK_DAMAGE = TConstruct.makeTranslation((String)"modifier", (String)"dominate.attack_damage");

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!world.f_46443_) {
            persistentData.putFloat(this.KEY, holder.m_21223_());
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE, ModifierHooks.ATTRIBUTES);
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)this.getId());
        return null;
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        ModDataNBT persistentData;
        float value;
        if (this.isArmor(slot) && (value = (persistentData = tool.getPersistentData()).getFloat(this.KEY)) != 0.0f) {
            consumer.accept(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ead86e6d-75d7-440f-acae-159b530f5eee"), Attributes.f_22281_.m_22087_(), Math.cbrt(value), AttributeModifier.Operation.ADDITION));
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT persistentData;
        float value;
        double boost;
        if (tool.hasTag(TinkerTags.Items.ARMOR) && (boost = Math.cbrt(value = (persistentData = tool.getPersistentData()).getFloat(this.KEY))) != 0.0) {
            tooltip.add((Component)this.applyStyle(Component.m_237115_((String)Util.PERCENT_BOOST_FORMAT.format(boost)).m_130946_(" ").m_7220_(ATTACK_DAMAGE)));
        }
    }
}

